import pandas as pd  
import pickle 
from decision_company import read_csv_file, fetch_column
  
# Load the dataset  
credit_customers = read_csv_file("credit_customers.csv")  

result = ("K-means", {"n_clusters": 4, "random_state": 42}, fetch_column(credit_customers, ['credit_history', 'age', 'employment', 'credit_amount', 'savings_status', 'cluster']))

print("result:\n", result)    
pickle.dump(result,open("./ref_result/result.pkl","wb"))